// ODView.cpp
/////////////////////////////////////////////////////////

// (C) Copyright 1999 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//

#include "stdafx.h"           // MFC stuff

#include <acdb.h>             // acdb definitions
#include <adslib.h>           // ads defs
#include "resourcehelper.h"   // temporary resource class
#include <rxmfcapi.h>         // ACAD MFC stuff
#include <rxregsvc.h>         // unlock application

#include "aced.h"             // aced stuff
#include "ODView.h"           // this project

// MFC support
extern HWND adsw_acadMainWnd();
HINSTANCE _hdllInstance;
extern BOOL InitModule(HINSTANCE, DWORD, LPVOID);
HWND hWndACAD = NULL;

extern void InitMFC();
extern void EndMFC();


// includes from ObjectARX Wizard
#ifdef _DEBUG
#define _DEBUG_WAS_DEFINED
#undef _DEBUG
#endif
#include "stdafx.h"           // MFC stuff
#ifdef _DEBUG_WAS_DEFINED
#define _DEBUG
#undef _DEBUG_WAS_DEFINED
#endif
#include "acdb.h"             // acdb definitions
#include "adslib.h"           // ads defs
#include "aced.h"             // aced stuff
#include "resourcehelper.h"   // temporary resource class
#include "rxmfcapi.h"         // ACAD MFC stuff
#include "rxregsvc.h"         // unlock application
#include "adsmigr.h"

#include "input.h"         // unlock application
#include "resource.h"   // temporary resource class

// message handlers
static AcRx::AppRetCode OnInitApp();
static void OnUnloadApp();
static void OnLoadDwg();
static void OnSaveDwg();
static void OnClosedDwg();
static void OnSaveComplete(AcDbDatabase *pDwg, const char *pActualName);
static void OnkInvkSubrMsg();
static void	OnUnloadDwg();

// helper functions
extern void InitMFC();
extern void EndMFC();
BOOL InitModule(HINSTANCE, DWORD, LPVOID);
BOOL startDlg();
void ShowDockablePane();
void HideDockablePane();

#include "DockPane.h"

CDockPane* pDockPane = NULL;


// end of declaration

/////////////////////////////////////////////////////////////////////
// acrxEntryPoint(internal)
// This function is the entry point for your application.
/////////////////////////////////////////////////////////////////////
extern "C" AcRx::AppRetCode acrxEntryPoint(AcRx::AppMsgCode msg, void* ptr)
{
  
	switch (msg)
	{
	case AcRx::kInitAppMsg:
		acrxRegisterAppMDIAware(ptr);
		return OnInitApp();
		break;

	case AcRx::kUnloadAppMsg:
		OnUnloadApp();
		break;

	case AcRx::kLoadDwgMsg:
		OnLoadDwg();
		break;

	case AcRx::kSaveMsg:
		OnSaveDwg();
		break;

	case AcRx::kUnloadDwgMsg:
		OnUnloadDwg();
		break;

    case AcRx::kInvkSubrMsg:
      OnkInvkSubrMsg();

	default:
		break;
	}

	return AcRx::kRetOK;
}

//---------------------------------------------------------------------------
// OnInitApp
//
static AcRx::AppRetCode OnInitApp()
{
	AcRx::AppRetCode retCode = AcRx::kRetOK;
	
	InitMFC();
	
	// register your autocad commands
	acedRegCmds->addCommand("ODVIEW", "ODVIEW", "ODVIEW", ACRX_CMD_TRANSPARENT, odview);

	return retCode;
  
} // END initApp()

//---------------------------------------------------------------------------
// OnLoadDwg
//
static void OnLoadDwg()
{
	if (NULL == pDockPane)
	{
		// This is the first time a drawing is loaded (since InitApp())
		startDlg();
		pDockPane->OnLoadDwg();
	}
	else
	{
		// Initialize contents
		ShowDockablePane();
		pDockPane->OnLoadDwg();
	}
}

//---------------------------------------------------------------------------
// OnUnloadDwg
//
static void	OnUnloadDwg()
{
	//check to see if any documents are open. If not,
	//then close the window
	int nOpenDoc = acDocManager->documentCount();
	if (1 == nOpenDoc)
	{
		if(NULL != pDockPane)
		{
			HideDockablePane();
		}
	}
}

//---------------------------------------------------------------------------
// OnkInvkSubrMsg
//
static void OnkInvkSubrMsg(void)
{
	//TODO
}


//---------------------------------------------------------------------------
// OnUnloadApp
//
static void
OnUnloadApp()
{
	acedRegCmds->removeGroup("ODVIEW");
	EndMFC();
}

//---------------------------------------------------------------------------
// OnSaveDwg
//
static void
OnSaveDwg()
{
	//TODO
}


//---------------------------------------------------------------------------
// OnClosedDwg
//
static void
OnClosedDwg()
{
	/*VOID*/
}


//---------------------------------------------------------------------------
// OnCommandEnded
//
static void
OnSaveComplete(AcDbDatabase *pDwg, const char *pActualName)
{
	//TODO
}


//---------------------------------------------------------------------------
// MFC Initialization
//
void InitMFC()
{
  InitModule(_hdllInstance, DLL_PROCESS_ATTACH, NULL);
}

//---------------------------------------------------------------------------
void EndMFC()
{
  InitModule(_hdllInstance, DLL_PROCESS_DETACH, NULL);
}

static AFX_EXTENSION_MODULE arxmfcDLL;

//---------------------------------------------------------------------------
extern "C" APIENTRY
DllMain (HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		_hdllInstance = hInstance;
	}
	return 1;
}

//---------------------------------------------------------------------------
extern BOOL InitModule(HINSTANCE hInstance, DWORD dwReason, LPVOID)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		if (!AfxInitExtensionModule(arxmfcDLL, hInstance))
		return 0;

		CTemporaryResourceOverride::SetDefaultResource(_hdllInstance);
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		AfxTermExtensionModule(arxmfcDLL);
		// end of cleanup
	}
	
	return 1;
}

//---------------------------------------------------------------------------
//
void odview()
{
	startDlg();
}

//---------------------------------------------------------------------------
// Create the dockable pane
//
BOOL startDlg()
{
	// when resource from this ARX app is needed,
    // instantiate a local object of CTemporaryResourceOverride    
    CTemporaryResourceOverride   useThisDllResource;

	if(pDockPane) //already open
		return TRUE;
	
	CFrameWnd *pMainFrame = acedGetAcadFrame();
	ASSERT(pMainFrame);

	pDockPane = new CDockPane;
	assert(pDockPane);

	CTemporaryResourceOverride TemporaryResourceOverride;
	return pDockPane->Create(pMainFrame);
}

//---------------------------------------------------------------------------
// Show the dockable pane. If it is not created,
// then create it and then show it
//
void ShowDockablePane()
{
	// Does the dockable pane need to be created ?
	if (NULL == pDockPane)
	{
		startDlg();
	}

	ASSERT(pDockPane);
	CMDIFrameWnd *pAcadFrame = acedGetAcadFrame();
	assert(pAcadFrame);
	pAcadFrame->ShowControlBar(pDockPane, TRUE, FALSE);	
}

//---------------------------------------------------------------------------
// Hide the dockable pane
//
void HideDockablePane()
{
	ASSERT(pDockPane);
	CMDIFrameWnd *pAcadFrame = acedGetAcadFrame();
	assert(pAcadFrame);
	pAcadFrame->ShowControlBar(pDockPane, FALSE, FALSE);
}
